GO
IF EXISTS (SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_RC_CLI_FIDELI_PONTOS_CREDITO_UPD')
begin
	DROP TRIGGER [dbo].[TRG_RC_CLI_FIDELI_PONTOS_CREDITO_UPD]
end
go

CREATE TRIGGER [dbo].[TRG_RC_CLI_FIDELI_PONTOS_CREDITO_UPD] ON [dbo].[RC_CLI_FIDELI_PONTOS_CREDITO] FOR 
UPDATE AS
begin
	
	IF CONTEXT_INFO() = 0x77777 
		RETURN


	IF EXISTS (SELECT r.CD_EMP 
			   FROM RC_CLI r INNER JOIN DELETED d ON
					r.CD_EMP = d.CD_EMP
					AND r.CD_CLI = d.CD_CLI
			   WHERE r.QTDE_PONTOS < d.QTDE_PONTOS)
		
	  BEGIN
		RAISERROR ('Saldo de pontos do cliente insuficiente para esta transacao.',16, 1); 
		RETURN;
	  END 
		

	--Deletando dados de pontos
	-----------------------------------------------------------------------------
	UPDATE
		c
	SET
		c.QTDE_PONTOS = ISNULL(c.QTDE_PONTOS,0) - ISNULL(d.QTDE_PONTOS,0)
	FROM
		RC_CLI c INNER JOIN DELETED d  ON
		c.CD_EMP = d.CD_EMP AND
		c.CD_CLI = d.CD_CLI AND
		c.TP_CONS_FINAL <> 1

	--Alterando dados de pontos
	-----------------------------------------------------------------------------
	UPDATE
		c
	SET
		c.QTDE_PONTOS = ISNULL(c.QTDE_PONTOS,0) + ISNULL(i.QTDE_PONTOS,0)
	FROM
		RC_CLI c INNER JOIN INSERTED i  ON
		c.CD_EMP = i.CD_EMP AND
		c.CD_CLI = i.CD_CLI AND
		c.TP_CONS_FINAL <> 1

end


